/**
* \file: DummyMediaBrowserSource.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: K. Kuroda / ADITJ/SW / kkuroda@jp.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <string>

#include "DummyMediaBrowserSource.h"

LOG_IMPORT_CONTEXT(aauto_media_browser);

namespace adit { namespace aauto {
using std::string;

DummyMediaBrowserSource::DummyMediaBrowserSource(uint8_t inSessionId,
        MessageRouter* inMessageRouter) : AditMediaBrowser(inSessionId,
                inMessageRouter)
{
    impl = new DummyMediaBrowserImpl(this, (void*) inMessageRouter);
}

DummyMediaBrowserSource::~DummyMediaBrowserSource()
{
    /* impl id deleted at GalReceiver destruction,
     * it is registered as a callback and hold in a shared pointer */
}

void DummyMediaBrowserSource::setConfigItem(string inKey, string inValue)
{
    impl->setConfigItem(inKey, inValue);
}

void DummyMediaBrowserSource::registerCallbacks(
        IAditMediaBrowserCallbacks* inCallbacks)
{
    impl->registerCallbacks(inCallbacks);
}

bool DummyMediaBrowserSource::init()
{
    LOG_INFO((aauto_media_browser, "test media browser initialize"));
    return impl->init();
}

void DummyMediaBrowserSource::shutdown()
{
    LOG_INFO((aauto_media_browser, "test media browser shut down"));
    impl->shutdown();
}

DummyMediaBrowserImpl::DummyMediaBrowserImpl(
        MediaBrowserEndpoint* inEndpoint, void* inSessionContext)
{
    mEndpoint = inEndpoint;
    mSessionContext = inSessionContext;
    mCallbacks = nullptr;
}

DummyMediaBrowserImpl::~DummyMediaBrowserImpl()
{
    shutdown();
}

void DummyMediaBrowserImpl::setConfigItem(string inKey, string inValue)
{
    // No configuration is needed for now, so the empty implementation
    (void) inKey;
    (void) inValue;
}

void DummyMediaBrowserImpl::registerCallbacks(
        IAditMediaBrowserCallbacks* inCallbacks)
{
    mCallbacks = inCallbacks;
}

bool DummyMediaBrowserImpl::init()
{
    mEndpoint->registerCallbacks(this);
    return true;
}

void DummyMediaBrowserImpl::shutdown()
{
    // nothing to do
}


// callback functions
void DummyMediaBrowserImpl::rootNodeCallback(const struct MediaRootNodeStruct &node)
{
    LOG_INFO((aauto_media_browser, "rootNodeCallback"));
    
    if(mCallbacks != nullptr)
    {
        mCallbacks->rootNodeCallback(node);
    } 
}
void DummyMediaBrowserImpl::sourceNodeCallback(const struct MediaSourceNodeStruct &node)
{
    LOG_INFO((aauto_media_browser, "sourceNodeCallback"));

    if(mCallbacks != nullptr)
    {
        mCallbacks->sourceNodeCallback(node);
    } 
}
void DummyMediaBrowserImpl::listNodeCallback(const struct MediaListNodeStruct &node)
{
    LOG_INFO((aauto_media_browser, "listNodeCallback"));
    
    if(mCallbacks != nullptr)
    {
        mCallbacks->listNodeCallback(node);
    } 
}
void DummyMediaBrowserImpl::songNodeCallback (const struct MediaSongNodeStruct &node)
{
    LOG_INFO((aauto_media_browser, "songNodeCallback"));

    if(mCallbacks != nullptr)
    {
        mCallbacks->songNodeCallback(node);
    } 
}

} } /* namespace adit { namespace aauto { */
